package gov.va.med.mhv.sm.admin.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import gov.va.med.mhv.sm.admin.enums.ParticipantTypeEnum;
import gov.va.med.mhv.sm.admin.serializer.CustomDateSerializer;

public class TriageGroupDTO implements Serializable {

	private static final long serialVersionUID = 7379153360178686747L;

	private static final String SUCCESSFUL = "Successful";
	private static final String UNSUCCESSFUL = "Unsuccessful";

	private Long id;
	private Boolean active;

//	@JsonFormat(pattern = "EEE, dd MMM yyyy HH:mm:ss z")
//	@JsonSerialize(using = CustomDateSerializer.class)
//	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm a z")
	private Date createdDate;	
	
	private String description;	

//	@JsonFormat(pattern = "EEE, dd MMM yyyy HH:mm:ss z")
//	@JsonSerialize(using = CustomDateSerializer.class)
	private Date modifiedDate;	
	private String name;	
	private Integer oplock;	
	private Set<TriageRelationDTO> relations;	
	private String vistaDiv;
	
	public TriageGroupDTO(){

	}
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Boolean getActive() {
		return active;
	}

	public void setActive(Boolean active) {
		this.active = active;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Set<TriageRelationDTO> getRelations() {
		return relations;
	}

	public void setRelations(Set<TriageRelationDTO> relations) {
		this.relations = relations;
	}

	public String getVistaDiv() {
		return vistaDiv;
	}

	public void setVistaDiv(String vistaDiv) {
		this.vistaDiv = vistaDiv;
	}
	
	public void addRelation(TriageRelationDTO tr) {
		tr.setTriageGroup(this);
		this.getRelations().add(tr);
	}
	
	public void removeRelation(TriageRelationDTO tr) {
		tr.setTriageGroup(null);
		getRelations().remove(tr);
	}

	public ParticipantTypeEnum getParticipantType() {
		return ParticipantTypeEnum.TRIAGE_GROUP;
	}


}